#include "myopengl33renderer.h"

// ----------------------------------------------------------------------------------------------------------------------------

CMyOpenGL33Renderer::CMyOpenGL33Renderer()
{
	Pause = false;
}

CMyOpenGL33Renderer::~CMyOpenGL33Renderer()
{
}

bool CMyOpenGL33Renderer::Init()
{
	bool Error = false;

	// load textures and shaders first ----------------------------------------------------------------------------------------

	Error |= !ShaderProgram.Load("shader.vert", "shader.frag");

	// if an error occured, return false --------------------------------------------------------------------------------------

	if(Error)
	{
		return false;
	}

	// get uniform and attribute locations ------------------------------------------------------------------------------------

	ShaderProgram.UniformLocations = new GLuint[1];
	ShaderProgram.UniformLocations[0] = glGetUniformLocation(ShaderProgram, "ModelViewProjectionMatrix");

	ShaderProgram.AttribLocations = new GLuint[2];
	ShaderProgram.AttribLocations[0] = glGetAttribLocation(ShaderProgram, "vert_Color");
	ShaderProgram.AttribLocations[1] = glGetAttribLocation(ShaderProgram, "vert_Position");

	// set up VBO -------------------------------------------------------------------------------------------------------------

	float Data[] =
	{	// r, g, b, x, y, z
		1.0f, 0.0f, 0.0f, -0.4f,  0.1f,  0.0f,
		0.0f, 1.0f, 0.0f,  0.4f,  0.1f,  0.0f,
		0.0f, 0.0f, 1.0f,  0.0f,  0.7f,  0.0f,
		0.0f, 1.0f, 0.0f, -0.2f, -0.6f,  0.0f,
		1.0f, 1.0f, 0.0f,  0.2f, -0.6f,  0.0f,
		0.0f, 0.0f, 1.0f,  0.2f, -0.1f,  0.0f,
		0.0f, 0.0f, 1.0f,  0.2f, -0.1f,  0.0f,
		1.0f, 0.0f, 0.0f, -0.2f, -0.1f,  0.0f,
		0.0f, 1.0f, 0.0f, -0.2f, -0.6f,  0.0f
	};

	glGenBuffers(1, &VBO);
	glBindBuffer(GL_ARRAY_BUFFER, VBO);
	glBufferData(GL_ARRAY_BUFFER, 216, Data, GL_STATIC_DRAW);
	glBindBuffer(GL_ARRAY_BUFFER, 0); // don't forget to unbind current VBO

	// set up VAO -------------------------------------------------------------------------------------------------------------

	glGenVertexArrays(1, &VAO);
	glBindVertexArray(VAO);
	glBindBuffer(GL_ARRAY_BUFFER, VBO);
	glVertexAttribPointer(ShaderProgram.AttribLocations[0], 3, GL_FLOAT, GL_FALSE, 24, (void*)0);
	glEnableVertexAttribArray(ShaderProgram.AttribLocations[0]);
	glVertexAttribPointer(ShaderProgram.AttribLocations[1], 3, GL_FLOAT, GL_FALSE, 24, (void*)12);
	glEnableVertexAttribArray(ShaderProgram.AttribLocations[1]);
	glBindVertexArray(0); // don't forget to unbind current VAO

	return true;
}

void CMyOpenGL33Renderer::Resize(int Width, int Height)
{
	this->Width = Width;
	this->Width = Height;

	glViewport(0 , 0, Width, Height);

	ProjectionMatrix = perspective(45.0f, (float)Width / (float)Height, 0.125f, 512.0f);
}

void CMyOpenGL33Renderer::Render()
{
	// clear frame buffer -----------------------------------------------------------------------------------------------------

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	// set up matrices --------------------------------------------------------------------------------------------------------

	ModelViewProjectionMatrix = ProjectionMatrix * ModelMatrix;

	// render -----------------------------------------------------------------------------------------------------------------

	glEnable(GL_DEPTH_TEST);
	glEnable(GL_CULL_FACE);

	glUseProgram(ShaderProgram);

	glUniformMatrix4fv(ShaderProgram.UniformLocations[0], 1, GL_FALSE, &ModelViewProjectionMatrix);

	glBindVertexArray(VAO);

	glDrawArrays(GL_TRIANGLES, 0, 9);

	glBindVertexArray(0);
	glUseProgram(0);

	glDisable(GL_CULL_FACE);
	glDisable(GL_DEPTH_TEST);
}

bool CMyOpenGL33Renderer::Animate(float FrameTime)
{
	static float Angle = 0.0f;

	// increase angle of rotation ---------------------------------------------------------------------------------------------

	if(!Pause)
	{
		Angle += 22.5f * FrameTime;

		ModelMatrix = rotate(Angle, vec3(0.0f, 0.0f, 1.0f)) * translate(0.0f, sin(Angle / 16.0f) * 0.25f, -2.0f);
	}

	return !Pause;
}

void CMyOpenGL33Renderer::Destroy()
{
	ShaderProgram.Destroy();
}

void CMyOpenGL33Renderer::OnKeyDown(UINT Key)
{
	switch(Key)
	{
		case 'P':
			Pause = !Pause;
			break;
	}

	COpenGL33Renderer::OnKeyDown(Key);
}
