#version 120

uniform sampler2D ColorBuffer, NormalBuffer, DepthBuffer, SSAOBuffer;
uniform mat4x4 ProjectionBiasMatrixInverse;
uniform bool ShowPositionBuffer, ShowNormalBuffer, ShowDepthBuffer;

void main()
{
	if(ShowPositionBuffer)
	{
		float Depth = texture2D(DepthBuffer, gl_TexCoord[0].st).r;

		if(Depth < 1.0)
		{
			vec4 Position = ProjectionBiasMatrixInverse * vec4(gl_TexCoord[0].st, Depth, 1.0);
			Position.xyz /= Position.w;

			gl_FragColor = vec4(Position.xyz, 1.0);
		}
		else
		{
			gl_FragColor = vec4(vec3(0.0), 1.0);
		}
	}
	else if(ShowNormalBuffer)
	{
		gl_FragColor = texture2D(NormalBuffer, gl_TexCoord[0].st);
	}
	else if(ShowDepthBuffer)
	{
		float Depth = texture2D(DepthBuffer, gl_TexCoord[0].st).r;

		gl_FragColor = vec4(vec3(Depth), 1.0);
	}
	else
	{
		gl_FragColor = texture2D(ColorBuffer, gl_TexCoord[0].st);

		float SSAO = texture2D(SSAOBuffer, gl_TexCoord[0].st).r;

		gl_FragColor.rgb *= SSAO; 
	}
}
