#version 120

uniform sampler2D ColorBuffer, NormalBuffer, DepthBuffer, SSAOBuffer, RotationTexture;
uniform sampler2DShadow ShadowMap;
uniform mat4x4 ProjectionBiasMatrixInverse, ShadowMatrix;
uniform vec3 LightPosition, LightNormal;
uniform vec2 Samples[16];
uniform bool CalculateShadows, DoShadowFiltering, CalculateSSAO;

void main()
{
	float Depth = texture2D(DepthBuffer, gl_TexCoord[0].st).r;

	if(Depth < 1.0)
	{
		vec4 Position = ProjectionBiasMatrixInverse * vec4(gl_TexCoord[0].st, Depth, 1.0);
		Position /= Position.w;

		// shadows ------------------------------------------------------------------------------------------------------------

		float Shadow = 1.0;

		if(CalculateShadows)
		{
			vec4 ShadowTexCoord = ShadowMatrix * Position;

			if(DoShadowFiltering)
			{
				vec4 RotationVector = normalize(texture2D(RotationTexture, gl_TexCoord[1].st) * 2.0 - 1.0);

				mat2x2 RotationMatrix = mat2x2(RotationVector.xy, RotationVector.zw);

				Shadow = 0.0;

				for(int i = 0; i < 16; i++)
				{
					Shadow += shadow2DProj(ShadowMap, ShadowTexCoord + vec4(RotationMatrix * Samples[i] * ShadowTexCoord.w, -0.0009765625 * ShadowTexCoord.w, 0.0)).r;
				}

				Shadow *= 0.0625;
			}
			else
			{
				ShadowTexCoord.z -= 0.0009765625 * ShadowTexCoord.w;

				Shadow = shadow2DProj(ShadowMap, ShadowTexCoord).r;
			}
		}

		// ssao ---------------------------------------------------------------------------------------------------------------

		float SSAO = 1.0;

		if(CalculateSSAO)
		{
			SSAO = texture2D(SSAOBuffer, gl_TexCoord[0].st).r;
		}

		// lighting -----------------------------------------------------------------------------------------------------------

		vec3 Normal = normalize(texture2D(NormalBuffer, gl_TexCoord[0].st).rgb * 2.0 - 1.0);

		vec3 LightDirection = LightPosition - Position.xyz;

		float LightDistance2 = dot(LightDirection, LightDirection);
		float LightDistance = sqrt(LightDistance2);

		LightDirection /= LightDistance;

		float LightIntensity = max(-dot(LightDirection, LightNormal), 0.0) / (1.0 + 0.0625 * LightDistance + 0.03125 * LightDistance2);

		float NdotLD = max(dot(LightDirection, Normal), 0.0) * LightIntensity * Shadow;

		float CDdotLDR = 0.0;

		vec4 Color = texture2D(ColorBuffer, gl_TexCoord[0].st);

		if(Color.a > 0.0)
		{
			vec3 LightDirectionReflected = reflect(-LightDirection, Normal);

			CDdotLDR = pow(max(dot(normalize(-Position.xyz), LightDirectionReflected), 0.0), Color.a * 128) * Shadow * LightIntensity;
		}

		gl_FragColor = vec4(Color.rgb * (0.33 * SSAO + 0.66 * NdotLD) + CDdotLDR, 1.0);
	}
	else
	{
		gl_FragColor = vec4(vec3(0.0), 1.0);
	}
}
