#version 120

uniform sampler2D NormalBuffer, DepthBuffer, RotationTexture;
uniform mat4x4 ProjectionBiasMatrixInverse;
uniform vec2 Samples[16];

void main()
{
	float Depth = texture2D(DepthBuffer, gl_TexCoord[0].st).r;

	if(Depth < 1.0)
	{
		vec3 Normal = normalize(texture2D(NormalBuffer, gl_TexCoord[0].st).rgb * 2.0 - 1.0);

		vec4 Position = ProjectionBiasMatrixInverse * vec4(gl_TexCoord[0].st, Depth, 1.0);
		Position.xyz /= Position.w;

		if(dot(Normal, Position.xyz) > 0.0)
		{
			Normal = -Normal;
		}

		vec4 ScaleRotationVector = normalize(texture2D(RotationTexture, gl_TexCoord[1].st) * 2.0 - 1.0) / length(Position.xyz);

		mat2x2 ScaleRotationMatrix = mat2x2(ScaleRotationVector.xy, ScaleRotationVector.zw);

		float SSAO = 0.0;

		for(int i = 0; i < 16; i++)
		{
			vec2 TexCoord = clamp(ScaleRotationMatrix * Samples[i] + gl_TexCoord[0].st, 0.0, 0.999999);

			float depth = texture2D(DepthBuffer, TexCoord).r;

			vec4 position = ProjectionBiasMatrixInverse * vec4(TexCoord, depth, 1.0);
			position.xyz /= position.w;

			vec3 P2P = position.xyz - Position.xyz;

			float Distance2 = dot(P2P, P2P);

			float Weight = 1.0 - Distance2 * 0.25;

			if(Weight > 0.0)
			{
				P2P /= sqrt(Distance2);

				float NdotP2P = dot(Normal, P2P);

				if(NdotP2P > 0.342)
				{
					SSAO += NdotP2P * Weight;
				}
			}
		}

		gl_FragColor = vec4(vec3(1.0 - SSAO * 0.0625), 1.0);
	}
	else
	{
		gl_FragColor = vec4(vec3(0.0), 1.0);
	}
}
