#version 120

uniform sampler2D Texture, NormalMap;
uniform bool Texturing, NormalMapping;

varying vec3 Tangent, Binormal, Normal;

void main()
{
	gl_FragData[0] = gl_Color;

	if(Texturing)
	{
		gl_FragData[0].rgb *= texture2D(Texture, gl_TexCoord[0].st).rgb;
	}

	if(NormalMapping)
	{
		vec3 NormalMapNormal = normalize(texture2D(NormalMap, gl_TexCoord[0].st).rgb * 2.0 - 1.0);

		NormalMapNormal = mat3x3(Tangent, Binormal, Normal) * NormalMapNormal;

		gl_FragData[1] = vec4(NormalMapNormal * 0.5 + 0.5, 1.0);
	}
	else
	{
		gl_FragData[1] = vec4(normalize(Normal) * 0.5 + 0.5, 1.0);
	}
}
