#version 120

uniform sampler2D Texture;

uniform int Texturing;

varying vec3 Position, Normal;

void main()
{
	vec3 LightDirection = gl_LightSource[0].position.xyz - Position;
	float LightDistance2 = dot(LightDirection, LightDirection);
	float LightDistance = sqrt(LightDistance2);
	LightDirection /= LightDistance;
	float Attenuation = gl_LightSource[0].constantAttenuation;
	Attenuation += gl_LightSource[0].linearAttenuation * LightDistance;
	Attenuation += gl_LightSource[0].quadraticAttenuation * LightDistance2;
	float NdotLD = max(dot(normalize(Normal), LightDirection), 0.0);
	vec3 Light = (gl_LightSource[0].ambient.rgb + gl_LightSource[0].diffuse.rgb * NdotLD) / Attenuation;
	gl_FragColor.rgb = gl_Color.rgb;
	if(Texturing == 1) gl_FragColor.rgb *= texture2D(Texture, gl_TexCoord[0].st).rgb;
	gl_FragColor.rgb *= Light;
}
