package joglni;

public final class OpenGLView
{
    // ------------------------------------------------------------------------------------------------------------------------

    static
    {
        System.loadLibrary("joglni");
    }

    // ------------------------------------------------------------------------------------------------------------------------

    private final OpenGLRenderer openglRenderer;

    // ------------------------------------------------------------------------------------------------------------------------

    public OpenGLView(OpenGLRenderer openglRenderer)
    {
        this.openglRenderer = openglRenderer;
    }

    // ------------------------------------------------------------------------------------------------------------------------

    public native boolean create21(String title, int width, int height, int samples);
    public native void destroy();
    public native void displayMessage(String title, String message);
    public native String getErrorLog();
    public native void mainLoop();
    public native void show(boolean maximized);

    // ------------------------------------------------------------------------------------------------------------------------

    private boolean onCreate()
    {
        if(openglRenderer != null)
        {
            return openglRenderer.init();
        }

        return true;
    }

    private void onPaint(float FrameTime)
    {
        if(openglRenderer != null)
        {
            openglRenderer.render(FrameTime);
        }
    }

    private void onSize(int width, int height)
    {
        if(openglRenderer != null)
        {
            openglRenderer.resize(width, height);
        }
    }

    private void onDestroy()
    {
        if(openglRenderer != null)
        {
            openglRenderer.destroy();
        }
    }

    // ------------------------------------------------------------------------------------------------------------------------
}
