import joglni.OpenGLRenderer;

public final class MyOpenGLRenderer extends OpenGLRenderer
{
    // ------------------------------------------------------------------------------------------------------------------------

    private final int[] textures = new int[1];
    private final int[] arrayBuffers = new int[3];
    private final int[] elementArrayBuffers = new int[1];

    private byte[] vertices;
    private byte[] texcoords;
    private byte[] data;
    private byte[] indices;

    private float angle = 0.0f;

    // ------------------------------------------------------------------------------------------------------------------------

    @Override
    public boolean init()
    {
        // --------------------------------------------------------------------------------------------------------------------

        glGenTextures(textures.length, textures);

        float[] pixels = new float[1024];

        for(int y = 0; y < 16; y++)
        {
            for(int x = 0; x < 16; x++)
            {
                int i = (y * 16 + x) * 4;

                pixels[i] = (float)x / 15.0f;
                pixels[i + 1] = (float)y / 15.0f;
                pixels[i + 2] = 0.0f;
                pixels[i + 3] = 1.0f;
            }
        }

        glBindTexture(GL_TEXTURE_2D, textures[0]);

        int textureFiltering = 1;

        if(textureFiltering == 1)
        {
            glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
            glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
            glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
            glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
        }
        else if(textureFiltering == 2)
        {
            glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
            glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
            glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
            glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
        }

        glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA8, 16, 16, 0, GL_RGBA, GL_FLOAT, getByteArray(pixels));

        glBindTexture(GL_TEXTURE_2D, 0);

        // --------------------------------------------------------------------------------------------------------------------

        glGenBuffers(arrayBuffers.length, arrayBuffers);

        float[] vertices = new float[]
        {   //  x,     y,     z
            -0.5f, -0.5f,  0.0f,
             0.5f, -0.5f,  0.0f,
             0.5f,  0.5f,  0.0f,
            -0.5f,  0.5f,  0.0f
        };

        this.vertices = getByteArray(vertices);

        glBindBuffer(GL_ARRAY_BUFFER, arrayBuffers[0]);
        glBufferData(GL_ARRAY_BUFFER, this.vertices.length, this.vertices, GL_STATIC_DRAW);
        glBindBuffer(GL_ARRAY_BUFFER, 0);

        float[] texcoords = new float[]
        {   //  s,     t
             0.0f,  0.0f,
             1.0f,  0.0f,
             1.0f,  1.0f,
             0.0f,  1.0f
        };

        this.texcoords = getByteArray(texcoords);

        glBindBuffer(GL_ARRAY_BUFFER, arrayBuffers[1]);
        glBufferData(GL_ARRAY_BUFFER, this.texcoords.length, this.texcoords, GL_STATIC_DRAW);
        glBindBuffer(GL_ARRAY_BUFFER, 0);

        float[] data = new float[]
        {   //  x,     y,     z,     s,     t
            -0.5f, -0.5f,  0.0f,  0.0f,  0.0f,
             0.5f, -0.5f,  0.0f,  1.0f,  0.0f,
             0.5f,  0.5f,  0.0f,  1.0f,  1.0f,
            -0.5f,  0.5f,  0.0f,  0.0f,  1.0f
        };

        this.data = getByteArray(data);

        glBindBuffer(GL_ARRAY_BUFFER, arrayBuffers[2]);
        glBufferData(GL_ARRAY_BUFFER, this.data.length, this.data, GL_STATIC_DRAW);
        glBindBuffer(GL_ARRAY_BUFFER, 0);

        // --------------------------------------------------------------------------------------------------------------------

        glGenBuffers(elementArrayBuffers.length, elementArrayBuffers);

        int[] indices = new int[]
        {
            0, 1, 2, // 1. triangle
            2, 3, 0  // 2. triangle
        };

        this.indices = getByteArray(indices);

        glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, elementArrayBuffers[0]);
        glBufferData(GL_ELEMENT_ARRAY_BUFFER, this.indices.length, this.indices, GL_STATIC_DRAW);
        glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, 0);

        // --------------------------------------------------------------------------------------------------------------------

        return true;

        // --------------------------------------------------------------------------------------------------------------------
    }

    // ------------------------------------------------------------------------------------------------------------------------

    @Override
    public void render(float FrameTime)
    {
        // --------------------------------------------------------------------------------------------------------------------

        glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

        // --------------------------------------------------------------------------------------------------------------------

        glMatrixMode(GL_MODELVIEW);
        glLoadIdentity();
        gluLookAt(0.0f, 0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);

        // --------------------------------------------------------------------------------------------------------------------

        glEnable(GL_DEPTH_TEST);
        glEnable(GL_CULL_FACE);

        // --------------------------------------------------------------------------------------------------------------------

        glRotatef(angle, 0.0f, 0.0f, 1.0f);

        // --------------------------------------------------------------------------------------------------------------------

        glEnable(GL_TEXTURE_2D);
        glBindTexture(GL_TEXTURE_2D, textures[0]);

        // --------------------------------------------------------------------------------------------------------------------

        glEnableClientState(GL_VERTEX_ARRAY);
        glEnableClientState(GL_TEXTURE_COORD_ARRAY);

        int method1 = 4;

        if(method1 == 1) // 2 vertex arrays
        {
            glVertexPointer(3, GL_FLOAT, 0, vertices, 0);
            glTexCoordPointer(2, GL_FLOAT, 0, texcoords, 0);
        }
        else if(method1 == 2) // 1 vertex array
        {
            glVertexPointer(3, GL_FLOAT, 20, data, 0);
            glTexCoordPointer(2, GL_FLOAT, 20, data, 12);
        }
        else if(method1 == 3) // 2 vertex buffer objects
        {
            glBindBuffer(GL_ARRAY_BUFFER, arrayBuffers[0]);
            glVertexPointer(3, GL_FLOAT, 0, null, 0);

            glBindBuffer(GL_ARRAY_BUFFER, arrayBuffers[1]);
            glTexCoordPointer(2, GL_FLOAT, 0, null, 0);

            glBindBuffer(GL_ARRAY_BUFFER, 0);
        }
        else if(method1 == 4) // 1 vertex buffer object
        {
            glBindBuffer(GL_ARRAY_BUFFER, arrayBuffers[2]);

            glVertexPointer(3, GL_FLOAT, 20, null, 0);
            glTexCoordPointer(2, GL_FLOAT, 20, null, 12);

            glBindBuffer(GL_ARRAY_BUFFER, 0);
        }

        // --------------------------------------------------------------------------------------------------------------------

        if(method1 >= 1 && method1 <= 4)
        {
            int method2 = 3;

            if(method2 == 1)
            {
                glDrawArrays(GL_QUADS, 0, 4);
            }
            else if(method2 == 2)
            {
                glDrawElements(GL_TRIANGLES, 6, GL_UNSIGNED_INT, indices);
            }
            else if(method2 == 3)
            {
                glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, elementArrayBuffers[0]);
                glDrawElements(GL_TRIANGLES, 6, GL_UNSIGNED_INT, null);
                glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, 0);
            }
        }

        // --------------------------------------------------------------------------------------------------------------------

        glDisableClientState(GL_TEXTURE_COORD_ARRAY);
        glDisableClientState(GL_VERTEX_ARRAY);

        // --------------------------------------------------------------------------------------------------------------------

        glBindTexture(GL_TEXTURE_2D, 0);
        glDisable(GL_TEXTURE_2D);

        // --------------------------------------------------------------------------------------------------------------------

        glDisable(GL_CULL_FACE);
        glDisable(GL_DEPTH_TEST);

        // --------------------------------------------------------------------------------------------------------------------

        angle += 11.25f * FrameTime;

        // --------------------------------------------------------------------------------------------------------------------
    }

    // ------------------------------------------------------------------------------------------------------------------------

    @Override
    public void resize(int width, int height)
    {
        // --------------------------------------------------------------------------------------------------------------------

        glViewport(0, 0, width, height);

        // --------------------------------------------------------------------------------------------------------------------

        glMatrixMode(GL_PROJECTION);
        glLoadIdentity();
        gluPerspective(45.0f, (float)width / (float)height, 0.125f, 512.0f);

        // --------------------------------------------------------------------------------------------------------------------
    }

    // ------------------------------------------------------------------------------------------------------------------------

    @Override
    public void destroy()
    {
        // --------------------------------------------------------------------------------------------------------------------

        glDeleteTextures(textures.length, textures);

        // --------------------------------------------------------------------------------------------------------------------

        glDeleteBuffers(arrayBuffers.length, arrayBuffers);

        // --------------------------------------------------------------------------------------------------------------------

        glDeleteBuffers(elementArrayBuffers.length, elementArrayBuffers);

        // --------------------------------------------------------------------------------------------------------------------
    }

    // ------------------------------------------------------------------------------------------------------------------------
}
