// ----------------------------------------------------------------------------------------------------------------------------

#include <jni.h>

// ----------------------------------------------------------------------------------------------------------------------------

#ifndef __joglni_h__
#define __joglni_h__
#define __JOGLNI_H__
#ifdef __cplusplus
extern "C" {
#endif

// OpenGL 1.1 -----------------------------------------------------------------------------------------------------------------

JNIEXPORT void JNICALL Java_joglni_OpenGL_glBegin(JNIEnv *env, jobject obj, jint mode);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glBindTexture(JNIEnv *env, jobject obj, jint target, jint texture);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glBlendFunc(JNIEnv *env, jobject obj, jint sfactor, jint dfactor);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glClear(JNIEnv *env, jobject obj, jint mask);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glColor3f(JNIEnv *env, jobject obj, jfloat red, jfloat green, jfloat blue);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glColor4f(JNIEnv *env, jobject obj, jfloat red, jfloat green, jfloat blue, jfloat alpha);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glColorPointer(JNIEnv *env, jobject obj, jint size, jint type, jint stride, jbyteArray ptr, jint offset);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glCullFace(JNIEnv *env, jobject obj, jint mode);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glDeleteTextures(JNIEnv *env, jobject obj, jint n, jintArray textures);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glDisable(JNIEnv *env, jobject obj, jint cap);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glDisableClientState(JNIEnv *env, jobject obj, jint cap);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glDrawArrays(JNIEnv *env, jobject obj, jint mode, jint first, jint count);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glDrawBuffer(JNIEnv *env, jobject obj, jint mode);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glDrawElements(JNIEnv *env, jobject obj, jint mode, jint count, jint type, jbyteArray indices);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glEnable(JNIEnv *env, jobject obj, jint cap);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glEnableClientState(JNIEnv *env, jobject obj, jint cap);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glEnd(JNIEnv *env, jobject obj);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glGenTextures(JNIEnv *env, jobject obj, jint n, jintArray textures);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glGetIntegerv(JNIEnv *env, jobject obj, jint pname, jintArray params);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glLineWidth(JNIEnv *env, jobject obj, jfloat width);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glLoadIdentity(JNIEnv *env, jobject obj);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glLoadMatrixf(JNIEnv *env, jobject obj, jfloatArray m);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glMatrixMode(JNIEnv *env, jobject obj, jint mode);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glMultMatrixf(JNIEnv *env, jobject obj, jfloatArray m);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glNormal3f(JNIEnv *env, jobject obj, jfloat nx, jfloat ny, jfloat nz);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glNormalPointer(JNIEnv *env, jobject obj, jint type, jint stride, jbyteArray ptr, jint offset);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glReadBuffer(JNIEnv *env, jobject obj, jint mode);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glRotatef(JNIEnv *env, jobject obj, jfloat angle, jfloat x, jfloat y, jfloat z);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glScalef(JNIEnv *env, jobject obj, jfloat x, jfloat y, jfloat z);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glTexCoord2f(JNIEnv *env, jobject obj, jfloat s, jfloat t);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glTexCoord3f(JNIEnv *env, jobject obj, jfloat s, jfloat t, jfloat r);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glTexCoordPointer(JNIEnv *env, jobject obj, jint size, jint type, jint stride, jbyteArray ptr, jint offset);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glTexImage2D(JNIEnv *env, jobject obj, jint target, jint level, jint internalFormat, jint width, jint height, jint border, jint format, jint type, jbyteArray pixels);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glTexParameteri(JNIEnv *env, jobject obj, jint target, jint pname, jint param);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glTranslatef(JNIEnv *env, jobject obj, jfloat x, jfloat y, jfloat z);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glVertex2f(JNIEnv *env, jobject obj, jfloat x, jfloat y);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glVertex3f(JNIEnv *env, jobject obj, jfloat x, jfloat y, jfloat z);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glVertexPointer(JNIEnv *env, jobject obj, jint size, jint type, jint stride, jbyteArray ptr, jint offset);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glViewport(JNIEnv *env, jobject obj, jint x, jint y, jint width, jint height);

// OpenGL 1.2 -----------------------------------------------------------------------------------------------------------------

JNIEXPORT void JNICALL Java_joglni_OpenGL_glTexImage3D(JNIEnv *env, jobject obj, jint target, jint level, jint internalFormat, jint width, jint height, jint depth, jint border, jint format, jint type, jbyteArray pixels);

// OpenGL 1.3 -----------------------------------------------------------------------------------------------------------------

JNIEXPORT void JNICALL Java_joglni_OpenGL_glActiveTexture(JNIEnv *env, jobject obj, jint texture);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glMultiTexCoord2f(JNIEnv *env, jobject obj, jint target, jfloat s, jfloat t);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glMultiTexCoord3f(JNIEnv *env, jobject obj, jint target, jfloat s, jfloat t, jfloat r);

// OpenGL 1.5 -----------------------------------------------------------------------------------------------------------------

JNIEXPORT void JNICALL Java_joglni_OpenGL_glBindBuffer(JNIEnv *env, jobject obj, jint target, jint buffer);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glBufferData(JNIEnv *env, jobject obj, jint target, jint size, jbyteArray data, jint usage);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glDeleteBuffers(JNIEnv *env, jobject obj, jint n, jintArray buffers);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glGenBuffers(JNIEnv *env, jobject obj, jint n, jintArray buffers);

// GL_ARB_texture_float -------------------------------------------------------------------------------------------------------

JNIEXPORT jboolean JNICALL Java_joglni_OpenGL_GL_1ARB_1texture_1float(JNIEnv *env, jobject obj);

// GL_ARB_texture_non_power_of_two --------------------------------------------------------------------------------------------

JNIEXPORT jboolean JNICALL Java_joglni_OpenGL_GL_1ARB_1texture_1non_1power_1of_1two(JNIEnv *env, jobject obj);

// GL_EXT_framebuffer_object --------------------------------------------------------------------------------------------------

JNIEXPORT void JNICALL Java_joglni_OpenGL_glBindFramebufferEXT(JNIEnv *env, jobject obj, jint target, jint framebuffer);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glDeleteFramebuffersEXT(JNIEnv *env, jobject obj, jint n, jintArray framebuffers);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glFramebufferTexture2DEXT(JNIEnv *env, jobject obj, jint target, jint attachment, jint textarget, jint texture, jint level);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glGenFramebuffersEXT(JNIEnv *env, jobject obj, jint n, jintArray framebuffers);
JNIEXPORT void JNICALL Java_joglni_OpenGL_glGenerateMipmapEXT(JNIEnv *env, jobject obj, jint target);

JNIEXPORT jboolean JNICALL Java_joglni_OpenGL_GL_1EXT_1framebuffer_1object(JNIEnv *env, jobject obj);

// GL_EXT_texture_array -------------------------------------------------------------------------------------------------------

JNIEXPORT void JNICALL Java_joglni_OpenGL_glFramebufferTextureLayerEXT(JNIEnv *env, jobject obj, jint target, jint attachment, jint texture, jint level, jint layer);

JNIEXPORT jboolean JNICALL Java_joglni_OpenGL_GL_1EXT_1texture_1array(JNIEnv *env, jobject obj);

// GL_EXT_texture_filter_anisotropic ------------------------------------------------------------------------------------------

JNIEXPORT jboolean JNICALL Java_joglni_OpenGL_GL_1EXT_1texture_1filter_1anisotropic(JNIEnv *env, jobject obj);

// GLU ------------------------------------------------------------------------------------------------------------------------

JNIEXPORT void JNICALL Java_joglni_OpenGL_gluPerspective(JNIEnv *env, jobject obj, jdouble fovy, jdouble aspect, jdouble zNear, jdouble zFar);
JNIEXPORT void JNICALL Java_joglni_OpenGL_gluLookAt(JNIEnv *env, jobject obj, jdouble eyeX, jdouble eyeY, jdouble eyeZ, jdouble centerX, jdouble centerY, jdouble centerZ, jdouble upX, jdouble upY, jdouble upZ);

// OpenGLRenderer -------------------------------------------------------------------------------------------------------------

JNIEXPORT void JNICALL Java_joglni_OpenGLRenderer_addError(JNIEnv *env, jobject obj, jstring error);

// OpenGLView -----------------------------------------------------------------------------------------------------------------

JNIEXPORT jboolean JNICALL Java_joglni_OpenGLView_create21(JNIEnv *env, jobject obj, jstring title, jint width, jint height, jint samples);
JNIEXPORT void JNICALL Java_joglni_OpenGLView_destroy(JNIEnv *env, jobject obj);
JNIEXPORT void JNICALL Java_joglni_OpenGLView_displayMessage(JNIEnv *env, jobject obj, jstring title, jstring message);
JNIEXPORT jstring JNICALL Java_joglni_OpenGLView_getErrorLog(JNIEnv *env, jobject obj);
JNIEXPORT void JNICALL Java_joglni_OpenGLView_mainLoop(JNIEnv *env, jobject obj);
JNIEXPORT void JNICALL Java_joglni_OpenGLView_show(JNIEnv *env, jobject obj, jboolean maximized);

// ----------------------------------------------------------------------------------------------------------------------------

#ifdef __cplusplus
}
#endif
#endif

// ----------------------------------------------------------------------------------------------------------------------------
