#version 120

uniform sampler2D Texture;

varying vec3 LD, Normal, EV, LDR;

void main()
{
	vec3 LDN = normalize(LD);
	vec3 NormalN = normalize(Normal);
	vec3 LDRN = normalize(LDR);
	vec3 EVN = normalize(EV);
	float NdotLD = max(dot(NormalN, LDN), 0.0);
	float EVdotLDR = pow(max(dot(EVN, LDRN), 0.0), 32.0);
	vec3 Color = texture2D(Texture, gl_TexCoord[0].st).rgb * (gl_LightSource[0].ambient.rgb + gl_LightSource[0].diffuse.rgb * (NdotLD + EVdotLDR));
	gl_FragColor = vec4(Color, 1.0);
}
