#version 120

uniform sampler2D NormalBuffer, DepthBuffer, RotationTexture;
uniform mat4x4 ProjectionBiasMatrixInverse;
uniform vec2 Samples[16];
uniform float Radius, Strength, ConstantAttenuation, LinearAttenuation, QuadraticAttenuation;

void main()
{
	float Depth = texture2D(DepthBuffer, gl_TexCoord[0].st).r;

	if(Depth < 1.0)
	{
		vec3 Normal = normalize(texture2D(NormalBuffer, gl_TexCoord[0].st).rgb * 2.0 - 1.0);

		vec4 Position = ProjectionBiasMatrixInverse * vec4(gl_TexCoord[0].st, Depth, 1.0);
		Position.xyz /= Position.w;

		if(dot(Normal, Position.xyz) > 0.0)
		{
			Normal = -Normal;
		}

		vec4 ScaleRotationVector = normalize(texture2D(RotationTexture, gl_TexCoord[1].st) * 2.0 - 1.0) * Radius;

		mat2x2 ScaleRotationMatrix = mat2x2(ScaleRotationVector.xy, ScaleRotationVector.zw);

		float SSAO = 0.0;

		for(int i = 0; i < 16; i++)
		{
			vec2 TexCoord = clamp(gl_TexCoord[0].st + ScaleRotationMatrix * Samples[i], 0.0, 0.999999);

			float SampleDepth = texture2D(DepthBuffer, TexCoord).r;

			vec4 SamplePosition = ProjectionBiasMatrixInverse * vec4(TexCoord, SampleDepth, 1.0);
			SamplePosition.xyz /= SamplePosition.w;

			vec3 P2SP = SamplePosition.xyz - Position.xyz;

			float Distance2 = dot(P2SP, P2SP);
			float Distance = sqrt(Distance2);

			float NdotP2SP = dot(Normal, P2SP) / Distance;

			if(NdotP2SP > 0.342)
			{
				SSAO += NdotP2SP / (ConstantAttenuation + Distance * LinearAttenuation + Distance2 * QuadraticAttenuation);
			}
		}

		gl_FragColor = vec4(vec3(1.0 - SSAO * 0.0625 * Strength), 1.0);
	}
	else
	{
		gl_FragColor = vec4(vec3(0.0), 1.0);
	}
}
