#version 120

#extension GL_EXT_texture_array : enable

uniform sampler2D ColorBuffer, NormalBuffer, DepthBuffer, SSAOBuffer;
uniform sampler2DArrayShadow ShadowCubeMaps;
uniform mat4x4 ProjectionBiasMatrixInverse, ViewMatrixInverse, ShadowMatrices[24];
uniform bool CalculateSSAO, CalculateShadows;

void main()
{
	gl_FragColor = texture2D(ColorBuffer, gl_TexCoord[0].st);

	float Depth = texture2D(DepthBuffer, gl_TexCoord[0].st).r;

	if(Depth < 1.0)
	{
		vec3 Normal = normalize(texture2D(NormalBuffer, gl_TexCoord[0].st).rgb * 2.0 - 1.0);

		vec4 Position = ProjectionBiasMatrixInverse * vec4(gl_TexCoord[0].st, Depth, 1.0);
		Position /= Position.w;

		float SSAO = CalculateSSAO ? texture2D(SSAOBuffer, gl_TexCoord[0].st).r : 1.0;

		vec3 Light = vec3(0.0);

		for(int i = 0; i < 4; i++)
		{
			vec3 LightDirection = gl_LightSource[i].position.xyz - Position.xyz;

			float LightDistance2 = dot(LightDirection, LightDirection);
			float LightDistance = sqrt(LightDistance2);

			LightDirection /= LightDistance;

			float NdotLD = max(dot(Normal, LightDirection), 0.0);

			float Attenuation = gl_LightSource[i].constantAttenuation;

			Attenuation += gl_LightSource[i].linearAttenuation * LightDistance;
			Attenuation += gl_LightSource[i].quadraticAttenuation * LightDistance2;

			float Shadow = 1.0;

			if(CalculateShadows)
			{
				LightDirection = (ViewMatrixInverse * vec4(LightDirection, 0.0)).xyz;

				float Axis[6];

				Axis[0] = -LightDirection.x;
				Axis[1] = LightDirection.x;
				Axis[2] = -LightDirection.y;
				Axis[3] = LightDirection.y;
				Axis[4] = -LightDirection.z;
				Axis[5] = LightDirection.z;

				int MaxAxisID = 0;

				for(int ii = 1; ii < 6; ii++)
				{
					if(Axis[ii] > Axis[MaxAxisID])
					{
						MaxAxisID = ii;
					}
				}

				int Index = i * 6 + MaxAxisID;

				vec4 ShadowTexCoord = ShadowMatrices[Index] * vec4(Position.xyz, 1.0);
				ShadowTexCoord.xyz /= ShadowTexCoord.w;
				ShadowTexCoord.w = ShadowTexCoord.z;
				ShadowTexCoord.z = float(Index);

				Shadow = shadow2DArray(ShadowCubeMaps, ShadowTexCoord).r;
			}

			Light += (gl_LightSource[i].ambient.rgb * SSAO + gl_LightSource[i].diffuse.rgb * NdotLD * Shadow) / Attenuation;
		}

		gl_FragColor.rgb *= Light;
	}
}
