#include "grid.h"

// ----------------------------------------------------------------------------------------------------------------------------

CGrid::CGrid()
{
	Normal = vec3(0.0f, 1.0f, 0.0f);
	D = 0.0f;
	Unit = 1.0f;
	PointFound = false;
}

CGrid::~CGrid()
{
}

void CGrid::Render()
{
	// ------------------------------------------------------------------------------------------------------------------------

	glTranslatef(Center.x, Center.y, Center.z);

	// ------------------------------------------------------------------------------------------------------------------------

	glLineWidth(2.0f);

	glBegin(GL_LINES);

	glColor3f(1.0f, 0.0f, 0.0f);

	glVertex3f(0.0f, 0.0f, 0.0f); glVertex3f(1.0f, 0.0f, 0.0f);
	glVertex3f(1.0f, 0.1f, 0.0f); glVertex3f(1.1f, -0.1f, 0.0f);
	glVertex3f(1.1f, 0.1f, 0.0f); glVertex3f(1.0f, -0.1f, 0.0f);

	glColor3f(0.0f, 1.0f, 0.0f);

	glVertex3f(0.0f, 0.0f, 0.0f); glVertex3f(0.0f, 1.0f, 0.0f);
	glVertex3f(-0.05f, 1.25f, 0.0f); glVertex3f(0.0f, 1.15f, 0.0f);
	glVertex3f(0.05f,1.25f, 0.0f); glVertex3f(0.0f, 1.15f, 0.0f);
	glVertex3f(0.0f,1.15f, 0.0f); glVertex3f(0.0f, 1.05f, 0.0f);

	glColor3f(0.0f, 0.0f, 1.0f);

	glVertex3f(0.0f,0.0f,0.0f); glVertex3f(0.0f, 0.0f, 1.0f);
	glVertex3f(-0.05f,0.1f,1.05f); glVertex3f(0.05f, 0.1f, 1.05f);
	glVertex3f(0.05f,0.1f,1.05f); glVertex3f(-0.05f, -0.1f, 1.05f);
	glVertex3f(-0.05f,-0.1f,1.05f); glVertex3f(0.05f, -0.1f, 1.05f);

	glEnd();

	glLineWidth(1.0f);

	// ------------------------------------------------------------------------------------------------------------------------

	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	glEnable(GL_POLYGON_OFFSET_FILL);
	glPolygonOffset(0.5f, 0.5f);

	if(Normal.x == 1.0f)
	{
		glColor4f(0.5f, 1.0f, 0.5f, 0.66f);

		glBegin(GL_LINES);

		float d = 50.0f * Unit;

		for(float i = -d; i <= d; i += Unit)
		{
			glVertex3f(0.0f, i, -d);
			glVertex3f(0.0f, i, d);
			glVertex3f(0.0f, -d, i);
			glVertex3f(0.0f, d, i);
		}

		glEnd();

		glColor4f(0.5f, 1.0f, 0.5f, 0.33f);

		glBegin(GL_QUADS);
			glVertex3f(0.0f, -d, -d);
			glVertex3f(0.0f, d, -d);
			glVertex3f(0.0f, d, d);
			glVertex3f(0.0f, -d, d);
		glEnd();
	}

	if(Normal.y == 1.0f)
	{
		glColor4f(0.5f, 1.0f, 0.5f, 0.66f);

		glBegin(GL_LINES);

		float d = 50.0f * Unit;

		for(float i = -d; i <= d; i += Unit)
		{
			glVertex3f(i, 0.0f, -d);
			glVertex3f(i, 0.0f, d);
			glVertex3f(-d, 0.0f, i);
			glVertex3f(d, 0.0f, i);
		}

		glEnd();

		glColor4f(0.5f, 1.0f, 0.5f, 0.33f);

		glBegin(GL_QUADS);
			glVertex3f(-d, 0.0f, -d);
			glVertex3f(d, 0.0f, -d);
			glVertex3f(d, 0.0f, d);
			glVertex3f(-d, 0.0f, d);
		glEnd();
	}

	if(Normal.z == 1.0f)
	{
		glColor4f(0.5f, 1.0f, 0.5f, 0.66f);

		glBegin(GL_LINES);

		float d = 50.0f * Unit;

		for(float i = -d; i <= d; i += Unit)
		{
			glVertex3f(i, -d, 0.0f);
			glVertex3f(i, d, 0.0f);
			glVertex3f(-d, i, 0.0f);
			glVertex3f(d, i, 0.0f);
		}

		glEnd();

		glColor4f(0.5f, 1.0f, 0.5f, 0.33f);

		glBegin(GL_QUADS);
			glVertex3f(-d, -d, 0.0f);
			glVertex3f(d, -d, 0.0f);
			glVertex3f(d, d, 0.0f);
			glVertex3f(-d, d, 0.0f);
		glEnd();
	}

	glPolygonOffset(0.0f, 0.0f);
	glDisable(GL_POLYGON_OFFSET_FILL);

	glDisable(GL_BLEND);

	// ------------------------------------------------------------------------------------------------------------------------

	glTranslatef(-Center.x, -Center.y, -Center.z);

	// ------------------------------------------------------------------------------------------------------------------------

	if(PointFound)
	{
		glPointSize(3.0f);
		glColor3f(1.0f, 0.0f, 0.0f);
		glBegin(GL_POINTS);
		glVertex3fv(&Point);
		glEnd();
		glPointSize(1.0f);
	}

	// ------------------------------------------------------------------------------------------------------------------------
}

void CGrid::FindPoint(int X, int Y, int Width, int Height, const vec3 &CameraPosition, const mat4x4 &ViewMatrix, const mat4x4 &ViewMatrixInverse, const mat4x4 &ProjectionMatrix, const mat4x4 &ProjectionMatrixInverse)
{
	PointFound = false;

	vec4 Position = ViewMatrixInverse * (ProjectionMatrixInverse * (BiasMatrixInverse * vec4((float)X / (float)(Width - 1), 1.0f - (float)Y / (float)(Height - 1), 0.5f, 1.0f)));

	Position /= Position.w;

	vec3 Ray = normalize(*(vec3*)&Position - CameraPosition);

	float NdotR = -dot(Normal, Ray);

	if(NdotR != 0.0f)
	{
		float Distance = (dot(Normal, CameraPosition) + D) / NdotR;

		if(Distance > 0.0f)
		{
			Point = Ray * Distance + CameraPosition;

			PointFound = true;

			Point -= Center;

			Point /= Unit * 0.5f;

			float fx = Point.x - (int)Point.x;
			float fy = Point.y - (int)Point.y;
			float fz = Point.z - (int)Point.z;

			if(Normal.x == 0.0f) if((fx > 0.0f && fx >= 0.5f) || (fx < 0.0f && fx > -0.5f)) Point.x = ceil(Point.x); else Point.x = floor(Point.x);
			if(Normal.y == 0.0f) if((fy > 0.0f && fy >= 0.5f) || (fy < 0.0f && fy > -0.5f)) Point.y = ceil(Point.y); else Point.y = floor(Point.y);
			if(Normal.z == 0.0f) if((fz > 0.0f && fz >= 0.5f) || (fz < 0.0f && fz > -0.5f)) Point.z = ceil(Point.z); else Point.z = floor(Point.z);

			Point *= Unit * 0.5f;

			Point += Center;

			if(Normal.x == 1.0f) Point.x = D == 0.0f ? 0.0f : -D;
			if(Normal.y == 1.0f) Point.y = D == 0.0f ? 0.0f : -D;
			if(Normal.z == 1.0f) Point.z = D == 0.0f ? 0.0f : -D;

			Position = BiasMatrix * (ProjectionMatrix * (ViewMatrix * vec4(Point, 1.0f)));

			Position /= Position.w;

			PointScreenPosition.x = Position.x * (float)(Width - 1);
			PointScreenPosition.y = (1.0f - Position.y) * (float)(Height - 1);
		}
	}
}
